/**
* Script: stat.js
* Written by: Radnen
* Updated: 7/10/2010
**/

/**
* Basic Stat Object:
* - name: name of the stat.
* - min: low value.
* - max: high value.
**/
function Stat(name, min, max)
{
	if (!max) max = min;
	
	/* Public Data: */
	this.name = name;
	this.min = min;
	this.max = max;
	
	/* Private Data: */
	var v = max;
	
	/* Note: Implicit range rounding. */
	this.__defineSetter__("value", function(v) {
		if (v > this.max) { v = this.max; }
		else if (v < this.min) { v = this.min; }
		else value = v;
	});
	
	this.__defineGetter__("value", function() { return v; });
	
	this.toString = function() {
		return this.name + ": " + v + "/" + this.max;
	}
	
	this.toMax = function() { v = this.max; }
	this.toMin = function() { v = this.min; }
}